<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class UserDonation extends Eloquent {

	protected $table = 'user_donation';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('donation', 'user_id', 'requirement_id', 'service_id');

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function requirement()
	{
		return $this->belongsTo('HouseRequirement', 'requirement_id');
	}

	public function service()
	{
		return $this->belongsTo('HouseService', 'service_id');
	}

}