<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Client extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;
    protected $guarded = array('pass_confirmation');
    protected $fillable = array('name', 'email', 'birth_date', 'blood_type', 'government', 'city', 'mobile', 'password', 'last_don_date');
    protected $visible = array('name', 'email', 'blood_type', 'government', 'city', 'mobile', 'last_don_date');
    protected $hidden = array('password', 'pass_confirmation');

    public function articles()
    {
        return $this->hasMany('App\Article');
    }

    public function category()
    {
        return $this->hasMany('App\Category');
    }

    public function request()
    {
        return $this->hasOne('App\Request');
    }

    public function report()
    {
        return $this->hasMany('App\Report');
    }

}