<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateArticlesTable extends Migration {

	public function up()
	{
		Schema::create('articles', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->longText('image')->nullable();
			$table->string('title', 100);
			$table->text('body');
			$table->integer('client_id')->unsigned();
			$table->integer('article_id')->unsigned()->nullable();
			$table->integer('cat_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('articles');
	}
}