<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRequestsTable extends Migration {

	public function up()
	{
		Schema::create('requests', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('client_id');
			$table->string('name', 100);
			$table->string('age', 3);
			$table->string('blood_type', 10);
			$table->string('quantitiy', 3);
			$table->string('hospital_name', 255);
			$table->longText('hospital_address');
			$table->string('government', 100);
			$table->string('city', 100);
			$table->string('mobile', 20);
			$table->text('notes')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('requests');
	}
}