<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStoreTranslationsTable extends Migration {

	public function up()
	{
		Schema::create('store_translations', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->text('description')->nullable();
			$table->string('locale')->unique();
			$table->bigInteger('store_id')->unique()->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('store_translations');
	}
}