<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Favourite extends Eloquent {

	protected $table = 'favourites';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function user()
	{
		return $this->belongsTo('App\Models\User');
	}

	public function favoriteable()
	{
		return $this->morphTo();
	}

}