<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Item extends Eloquent {

	protected $table = 'items';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function drinks()
	{
		return $this->belongsToMany('App\Models\Drink', 'item_drinks', 'item_id', 'drink_id');
	}

	public function store()
	{
		return $this->belongsTo('App\Models\StoreCategory');
	}

	public function category()
	{
		return $this->belongsTo('App\Models\StoreCategory');
	}

	public function sides()
	{
		return $this->hasMany('App\Models\Side');
	}

}