<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Store extends Eloquent {

	protected $table = 'stores';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function points()
	{
		return $this->morphMany('App\Models\PointUser', 'pointeable');
	}

	public function admin()
	{
		return $this->belongsTo('App\Models\User');
	}

	public function sub_section()
	{
		return $this->belongsTo('App\Models\Subsection');
	}

	public function defaultCurrency()
	{
		return $this->belongsTo('App\Models\Currency');
	}

	public function toCurrency()
	{
		return $this->belongsTo('App\Models\Currency');
	}

	public function storeCategories()
	{
		return $this->hasMany('StoreCategory');
	}

}