<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('image');

	public function addresses()
	{
		return $this->hasMany('App\Models\Address');
	}

	public function reviews()
	{
		return $this->morphMany('App\Models\Review', 'reviewable');
	}

	public function searchHistories()
	{
		return $this->hasMany('App\Models\SearchHistory');
	}

	public function coupons()
	{
		return $this->hasOne('App\Models\Coupon', 'coupon_users', 'user_id', 'coupon_id');
	}

	public function notifeable()
	{
		return $this->morphMany('App\Models\Notification', 'notifeable');
	}

	public function tier()
	{
		return $this->belongsTo('App\Models\Tier');
	}

	public function teirPoints()
	{
		return $this->morphedByMany('App\Models\Tier', 'pointeable', 'point_users');
	}

	public function storePoints()
	{
		return $this->morphedByMany('App\Models\Store', 'pointeable', 'point_users');
	}

	public function punchcardPoints()
	{
		return $this->morphedByMany('App\Models\User', 'pointeable', 'point_users');
	}

	public function offerPoints()
	{
		return $this->morphedByMany('Offer', 'pointeable', 'point_users');
	}

}