<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateXcasesTable extends Migration {

	public function up()
	{
		Schema::create('xcases', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('case_uuid', 250);
			$table->bigInteger('client_id')->unsigned();
			$table->string('opponent_name', 250);
			$table->string('opponent_description', 250);
			$table->text('client_description')->default('512');
			$table->string('case_registration', 250);
			$table->date('case_registration_date')->nullable();
			$table->bigInteger('court_degree_id')->unsigned();
			$table->bigInteger('court_item_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('xcases');
	}
}