<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('user_type_id')->references('id')->on('user_type')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('subjects_items', function(Blueprint $table) {
			$table->foreign('case_id')->references('id')->on('xcases')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('courts_items', function(Blueprint $table) {
			$table->foreign('court_type_id')->references('id')->on('court_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('courts_items', function(Blueprint $table) {
			$table->foreign('court_name_id')->references('id')->on('court_names')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('courts_items', function(Blueprint $table) {
			$table->foreign('case_id')->references('id')->on('xcases')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('case_files_items', function(Blueprint $table) {
			$table->foreign('case_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('case_files_items', function(Blueprint $table) {
			$table->foreign('Judgment')->references('id')->on('Judgment')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Judgment', function(Blueprint $table) {
			$table->foreign('case_id')->references('id')->on('xcases')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Judgment', function(Blueprint $table) {
			$table->foreign('case_status_id')->references('id')->on('status')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('xcases', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('xcases', function(Blueprint $table) {
			$table->foreign('court_degree_id')->references('id')->on('case_settings')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('xcases', function(Blueprint $table) {
			$table->foreign('court_item_id')->references('id')->on('case_settings')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('users_offices', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('users_offices', function(Blueprint $table) {
			$table->foreign('office_id')->references('id')->on('offices')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('case_expenses', function(Blueprint $table) {
			$table->foreign('deposit_by_user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('case_expenses', function(Blueprint $table) {
			$table->foreign('deposit_for_user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('case_expenses', function(Blueprint $table) {
			$table->foreign('case_id')->references('id')->on('xcases')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('user_xcases', function(Blueprint $table) {
			$table->foreign('xcase_id')->references('id')->on('xcases')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('user_xcases', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_user_type_id_foreign');
		});
		Schema::table('subjects_items', function(Blueprint $table) {
			$table->dropForeign('subjects_items_case_id_foreign');
		});
		Schema::table('courts_items', function(Blueprint $table) {
			$table->dropForeign('courts_items_court_type_id_foreign');
		});
		Schema::table('courts_items', function(Blueprint $table) {
			$table->dropForeign('courts_items_court_name_id_foreign');
		});
		Schema::table('courts_items', function(Blueprint $table) {
			$table->dropForeign('courts_items_case_id_foreign');
		});
		Schema::table('case_files_items', function(Blueprint $table) {
			$table->dropForeign('case_files_items_case_id_foreign');
		});
		Schema::table('case_files_items', function(Blueprint $table) {
			$table->dropForeign('case_files_items_Judgment_foreign');
		});
		Schema::table('Judgment', function(Blueprint $table) {
			$table->dropForeign('Judgment_case_id_foreign');
		});
		Schema::table('Judgment', function(Blueprint $table) {
			$table->dropForeign('Judgment_case_status_id_foreign');
		});
		Schema::table('xcases', function(Blueprint $table) {
			$table->dropForeign('xcases_client_id_foreign');
		});
		Schema::table('xcases', function(Blueprint $table) {
			$table->dropForeign('xcases_court_degree_id_foreign');
		});
		Schema::table('xcases', function(Blueprint $table) {
			$table->dropForeign('xcases_court_item_id_foreign');
		});
		Schema::table('users_offices', function(Blueprint $table) {
			$table->dropForeign('users_offices_user_id_foreign');
		});
		Schema::table('users_offices', function(Blueprint $table) {
			$table->dropForeign('users_offices_office_id_foreign');
		});
		Schema::table('case_expenses', function(Blueprint $table) {
			$table->dropForeign('case_expenses_deposit_by_user_id_foreign');
		});
		Schema::table('case_expenses', function(Blueprint $table) {
			$table->dropForeign('case_expenses_deposit_for_user_id_foreign');
		});
		Schema::table('case_expenses', function(Blueprint $table) {
			$table->dropForeign('case_expenses_case_id_foreign');
		});
		Schema::table('user_xcases', function(Blueprint $table) {
			$table->dropForeign('user_xcases_xcase_id_foreign');
		});
		Schema::table('user_xcases', function(Blueprint $table) {
			$table->dropForeign('user_xcases_user_id_foreign');
		});
	}
}