<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCandidateCvCurrentEmploymentTable extends Migration {

	public function up()
	{
		Schema::create('candidate_cv_current_employment', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('cv_id')->unsigned();
			$table->string('title', 60)->nullable();
			$table->integer('job_category_id')->unsigned()->nullable();
			$table->integer('seniority_id')->unsigned()->nullable();
			$table->string('campany_name', 60)->nullable();
			$table->integer('location_id')->unsigned()->nullable();
			$table->integer('industry_id')->unsigned()->nullable();
			$table->integer('company_size_id')->unsigned()->nullable();
			$table->integer('company_nationality_type_id')->unsigned()->nullable();
			$table->string('net_salary', 30)->nullable();
			$table->integer('salary_currency_type_id')->unsigned()->nullable();
			$table->integer('salary_period_id')->unsigned()->nullable();
			$table->string('cash_benefits', 255)->nullable();
			$table->integer('benefit_period_id')->unsigned()->nullable();
			$table->text('other_benefits')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('candidate_cv_current_employment');
	}
}