<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCandidateCvEducationsTable extends Migration {

	public function up()
	{
		Schema::create('candidate_cv_educations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('cv_id')->unsigned();
			$table->string('university_name', 255);
			$table->integer('university_type_id')->unsigned();
			$table->integer('field_of_study_id')->unsigned();
			$table->date('start_date');
			$table->date('end_date');
			$table->boolean('currently_educating')->nullable()->default(0);
			$table->integer('degree_level_id')->unsigned();
			$table->string('gpa', 30);
		});
	}

	public function down()
	{
		Schema::drop('candidate_cv_educations');
	}
}