<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class CandidatePhoneNumber extends Eloquent {

	protected $table = 'candidate_phone_numbers';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('candidate_id', 'country_code_id', 'area_code', 'phone_number', 'type_id');

	public function candidate()
	{
		return $this->belongsTo('App\Candidate');
	}

	public function type()
	{
		return $this->belongsTo('App\Lookup', 'type_id');
	}

	public function countryCode()
	{
		return $this->belongsTo('App\Location', 'country_code_id');
	}

}