<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Hotel extends Model 
{

    protected $table = 'hotels';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'address', 'description', 'enable');

    public function routes()
    {
        return $this->hasMany('Hotel_location', 'hotel_id');
    }

    public function reservations()
    {
        return $this->hasMany('Reservation', 'hotel_id');
    }

    public function employee()
    {
        return $this->hasOne('Employee');
    }

}