<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PackageAction extends Model 
{

    protected $table = 'package_actions';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('reseptionist_id', 'action_id', 'pax', 'date', 'extra_price');
    protected $visible = array('action_id', 'pax', 'date', 'extra_price');

    public function action()
    {
        return $this->belongsTo('Action', 'action_id');
    }

    public function reservationPackage()
    {
        return $this->belongsTo('ReservationPackage', 'reservation_package_id');
    }

}