<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSoldPackagesTable extends Migration {

	public function up()
	{
		Schema::create('sold_packages', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('inherit_id')->unsigned()->nullable();
			$table->integer('direct_sells_id')->unsigned();
			$table->string('package_name', 100);
			$table->decimal('price', 10,4);
			$table->integer('pax');
			$table->decimal('total', 10,4);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('sold_packages');
	}
}