<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Reservation extends Model 
{

    protected $table = 'reservations';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function listing()
    {
        return $this->belongsTo('App\Listing');
    }

    public function conversations()
    {
        return $this->hasMany('App\Conversation');
    }

}