<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Order extends Eloquent {

	protected $table = 'orders';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id');

	public function products()
	{
		return $this->belongsToMany('Product');
	}

	public function users()
	{
		return $this->belongsTo('User');
	}

}