<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Store extends Eloquent {

	protected $table = 'stores';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function account()
	{
		return $this->belongsTo('Account', 'account_id');
	}

	public function products()
	{
		return $this->belongsToMany('Product');
	}

}