<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $guarded = array('id');

	public function account()
	{
		return $this->belongsTo('Account', 'account_id');
	}

	public function orders()
	{
		return $this->hasMany('Order', 'user_id');
	}

	public function groups()
	{
		return $this->belongsToMany('Group', 'users_groups');
	}

}