<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBranchTable extends Migration {

	public function up()
	{
		Schema::create('branch', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name_en')->nullable();
			$table->string('name_ar')->nullable();
			$table->double('latitude')->nullable();
			$table->double('longitude')->nullable();
			$table->text('address')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('branch');
	}
}