<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Rating extends Model 
{

    protected $table = 'rating';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('order_id', 'client_id', 'driver_id', 'quality', 'delivery', 'packaging', 'comment');

    public function client()
    {
        return $this->belongsTo('Client', 'client_id');
    }

    public function order()
    {
        return $this->belongsTo('Order', 'order_id');
    }

    public function driver()
    {
        return $this->belongsTo('Driver', 'driver_id');
    }

}