<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOfferTable extends Migration {

	public function up()
	{
		Schema::create('offer', function(Blueprint $table) {
			$table->softDeletes();
			$table->increments('id');
			$table->timestamps();
			$table->integer('product_id')->nullable();
			$table->string('title_en')->nullable();
			$table->string('title_ar')->nullable();
			$table->text('message_en')->nullable();
			$table->text('message_ar')->nullable();
			$table->string('button_en')->nullable();
			$table->string('button_ar')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('offer');
	}
}