<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateApplicationsTable extends Migration {

	public function up()
	{
		Schema::create('applications', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('first_name');
			$table->string('last_name');
			$table->string('email')->unique();
			$table->string('phone');
			$table->string('cv');
			$table->string('location');
			$table->string('linkedin');
			$table->string('website');
			$table->integer('vacancy_id')->unsigned();
			$table->integer('acceptness_id')->unsigned();
			$table->integer('job_title_id');
			$table->integer('job_category_id');
			$table->date('applied_date');
		});
	}

	public function down()
	{
		Schema::drop('applications');
	}
}