<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEmployeesTable extends Migration {

	public function up()
	{
		Schema::create('employees', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id')->unsigned();
			$table->string('ar_first_name');
			$table->string('ar_middle_name');
			$table->string('ar_last_name');
			$table->string('en_first_name');
			$table->string('en_middle_name');
			$table->string('en_last_name');
			$table->string('national_id');
			$table->string('salary');
			$table->enum('marital_status', array('single', 'engaged', 'married', 'divorced', 'widowed'));
			$table->string('phone');
			$table->string('personal_mail');
			$table->string('company_mail');
			$table->string('job_category_id');
			$table->string('job_title_id');
			$table->string('photo_id');
			$table->string('religion');
			$table->string('nationality');
			$table->string('country_id');
			$table->integer('industry_id');
			$table->date('birth_date');
			$table->string('school');
			$table->string('company');
			$table->string('club');
			$table->string('facebook');
			$table->string('notes');
			$table->string('address');
			$table->string('job_history');
			$table->string('city_id');
			$table->string('is_hr');
			$table->string('day_value');
			$table->string('finger_print_id');
			$table->string('annual_vacations');
			$table->string('unscheduled_vacation');
			$table->string('requested_vacation');
		});
	}

	public function down()
	{
		Schema::drop('employees');
	}
}