<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('companies', function(Blueprint $table) {
			$table->foreign('contract_id')->references('id')->on('contracts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('company_addresses', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('roles', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('job_titles', function(Blueprint $table) {
			$table->foreign('job_category_id')->references('id')->on('job_categories')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('applications', function(Blueprint $table) {
			$table->foreign('vacancy_id')->references('id')->on('vacancies')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('applications', function(Blueprint $table) {
			$table->foreign('acceptness_id')->references('id')->on('acceptness_type')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('vacancies', function(Blueprint $table) {
			$table->foreign('job_title_id')->references('id')->on('job_titles')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('vacancies', function(Blueprint $table) {
			$table->foreign('type_id')->references('id')->on('vacancies_type')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('employee_image', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('employee_vacatoin', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('vacations', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('vacations', function(Blueprint $table) {
			$table->foreign('vacations_types_id')->references('id')->on('vacancies_type')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('hr_settings', function(Blueprint $table) {
			$table->foreign('work_info_id')->references('id')->on('work_information')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('attendance', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('attendance_report', function(Blueprint $table) {
			$table->foreign('attendance_id')->references('id')->on('attendance')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('attendance_report', function(Blueprint $table) {
			$table->foreign('emp_data_status')->references('id')->on('date_status')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('emp_request', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('emp_request', function(Blueprint $table) {
			$table->foreign('Request_type_id')->references('id')->on('Request_type')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('emp_request', function(Blueprint $table) {
			$table->foreign('request_status_id')->references('id')->on('request_status')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('week_info', function(Blueprint $table) {
			$table->foreign('information_id')->references('id')->on('work_information')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('week_info', function(Blueprint $table) {
			$table->foreign('weekend_id')->references('id')->on('weekends')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('companies', function(Blueprint $table) {
			$table->dropForeign('companies_contract_id_foreign');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->dropForeign('companies_user_id_foreign');
		});
		Schema::table('company_addresses', function(Blueprint $table) {
			$table->dropForeign('company_addresses_country_id_foreign');
		});
		Schema::table('roles', function(Blueprint $table) {
			$table->dropForeign('roles_user_id_foreign');
		});
		Schema::table('job_titles', function(Blueprint $table) {
			$table->dropForeign('job_titles_job_category_id_foreign');
		});
		Schema::table('applications', function(Blueprint $table) {
			$table->dropForeign('applications_vacancy_id_foreign');
		});
		Schema::table('applications', function(Blueprint $table) {
			$table->dropForeign('applications_acceptness_id_foreign');
		});
		Schema::table('vacancies', function(Blueprint $table) {
			$table->dropForeign('vacancies_job_title_id_foreign');
		});
		Schema::table('vacancies', function(Blueprint $table) {
			$table->dropForeign('vacancies_type_id_foreign');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->dropForeign('employees_user_id_foreign');
		});
		Schema::table('employee_image', function(Blueprint $table) {
			$table->dropForeign('employee_image_employee_id_foreign');
		});
		Schema::table('employee_vacatoin', function(Blueprint $table) {
			$table->dropForeign('employee_vacatoin_employee_id_foreign');
		});
		Schema::table('vacations', function(Blueprint $table) {
			$table->dropForeign('vacations_employee_id_foreign');
		});
		Schema::table('vacations', function(Blueprint $table) {
			$table->dropForeign('vacations_vacations_types_id_foreign');
		});
		Schema::table('hr_settings', function(Blueprint $table) {
			$table->dropForeign('hr_settings_work_info_id_foreign');
		});
		Schema::table('attendance', function(Blueprint $table) {
			$table->dropForeign('attendance_employee_id_foreign');
		});
		Schema::table('attendance_report', function(Blueprint $table) {
			$table->dropForeign('attendance_report_attendance_id_foreign');
		});
		Schema::table('attendance_report', function(Blueprint $table) {
			$table->dropForeign('attendance_report_emp_data_status_foreign');
		});
		Schema::table('emp_request', function(Blueprint $table) {
			$table->dropForeign('emp_request_employee_id_foreign');
		});
		Schema::table('emp_request', function(Blueprint $table) {
			$table->dropForeign('emp_request_Request_type_id_foreign');
		});
		Schema::table('emp_request', function(Blueprint $table) {
			$table->dropForeign('emp_request_request_status_id_foreign');
		});
		Schema::table('week_info', function(Blueprint $table) {
			$table->dropForeign('week_info_information_id_foreign');
		});
		Schema::table('week_info', function(Blueprint $table) {
			$table->dropForeign('week_info_weekend_id_foreign');
		});
	}
}