<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCourtsTournamentsTable extends Migration {

	public function up()
	{
		Schema::create('courts_tournaments', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('tournament_id');
			$table->bigInteger('court_id');
			$table->tinyInteger('is_final');
			$table->time('start_time_at');
			$table->time('end_time_at');
			$table->date('match_at');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('courts_tournaments');
	}
}