<?php

namespace App\Models;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;
	protected $fillable = array('name', 'phone', 'email', 'blood_type_id', 'd_o_b', 'last_donation_date', 'city_id', 'pin_code', 'api_toke', 'password', 'blood_types');

	public function bloodType()
	{
		return $this->belongsTo('App\Models\BloodType');
	}

	public function city()
	{
		return $this->belongsTo('App\Models\City');
	}

	public function post()
	{
		return $this->belongsToMany('App\Models\Post');
	}

	public function notification()
	{
		return $this->belongsToMany('App\Models\Notification');
	}

	public function governorate()
	{
		return $this->belongsToMany('App\Models\Governorate');
	}

}