<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReviewsTable extends Migration {

	public function up()
	{
		Schema::create('reviews', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('media_id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->string('name');
			$table->string('slug');
			$table->string('video_url', 1024);
			$table->tinyInteger('status');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('reviews');
	}
}