<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('translations', function(Blueprint $table) {
			$table->foreign('file_id')->references('id')->on('files')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tmx_tu', function(Blueprint $table) {
			$table->foreign('file_id')->references('id')->on('files')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tmx_tuv', function(Blueprint $table) {
			$table->foreign('tu_id')->references('id')->on('tmx_tu')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tmx_tuv', function(Blueprint $table) {
			$table->foreign('file_id')->references('id')->on('files')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('translations', function(Blueprint $table) {
			$table->dropForeign('translations_file_id_foreign');
		});
		Schema::table('tmx_tu', function(Blueprint $table) {
			$table->dropForeign('tmx_tu_file_id_foreign');
		});
		Schema::table('tmx_tuv', function(Blueprint $table) {
			$table->dropForeign('tmx_tuv_tu_id_foreign');
		});
		Schema::table('tmx_tuv', function(Blueprint $table) {
			$table->dropForeign('tmx_tuv_file_id_foreign');
		});
	}
}