<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('tenant_id')->references('id')->on('tenants')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_group', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_group', function(Blueprint $table) {
			$table->foreign('group_id')->references('id')->on('groups')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('custom_messages', function(Blueprint $table) {
			$table->foreign('tenant_id')->references('id')->on('tenants')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('pacs_data', function(Blueprint $table) {
			$table->foreign('tenant_id')->references('id')->on('tenants')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_tenant_id_foreign');
		});
		Schema::table('user_group', function(Blueprint $table) {
			$table->dropForeign('user_group_user_id_foreign');
		});
		Schema::table('user_group', function(Blueprint $table) {
			$table->dropForeign('user_group_group_id_foreign');
		});
		Schema::table('custom_messages', function(Blueprint $table) {
			$table->dropForeign('custom_messages_tenant_id_foreign');
		});
		Schema::table('pacs_data', function(Blueprint $table) {
			$table->dropForeign('pacs_data_tenant_id_foreign');
		});
	}
}