<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderOffersTable extends Migration {

	public function up()
	{
		Schema::create('order_offers', function(Blueprint $table) {
			$table->timestamps();
			$table->bigIncrements('id', true)->primary();
			$table->enum('status', array('wait', 'accepted', 'refused'))->index();
			$table->bigInteger('provider_id')->unsigned();
			$table->double('price');
			$table->text('notes')->nullable();
			$table->bigInteger('order_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('order_offers');
	}
}