<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderProductsTable extends Migration {

	public function up()
	{
		Schema::create('order_products', function(Blueprint $table) {
			$table->timestamps();
			$table->softDeletes();
			$table->bigIncrements('id', true)->primary();
			$table->bigInteger('order_id')->unsigned();
			$table->bigInteger('product_id')->unsigned();
			$table->integer('quantity')->default('0');
			$table->double('price')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('order_products');
	}
}