<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('team_members', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('team_members', function(Blueprint $table) {
			$table->foreign('team_id')->references('id')->on('teams')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('matches', function(Blueprint $table) {
			$table->foreign('match_type_id')->references('id')->on('matches_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('matches', function(Blueprint $table) {
			$table->foreign('first_team_id')->references('id')->on('teams')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('matches', function(Blueprint $table) {
			$table->foreign('second_team_id')->references('id')->on('teams')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('matches', function(Blueprint $table) {
			$table->foreign('group_id')->references('id')->on('groups')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('medias', function(Blueprint $table) {
			$table->foreign('team_id')->references('id')->on('teams')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('medias', function(Blueprint $table) {
			$table->foreign('match_id')->references('id')->on('matches')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('news', function(Blueprint $table) {
			$table->foreign('team_id')->references('id')->on('teams')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('team_members', function(Blueprint $table) {
			$table->dropForeign('team_members_user_id_foreign');
		});
		Schema::table('team_members', function(Blueprint $table) {
			$table->dropForeign('team_members_team_id_foreign');
		});
		Schema::table('matches', function(Blueprint $table) {
			$table->dropForeign('matches_match_type_id_foreign');
		});
		Schema::table('matches', function(Blueprint $table) {
			$table->dropForeign('matches_first_team_id_foreign');
		});
		Schema::table('matches', function(Blueprint $table) {
			$table->dropForeign('matches_second_team_id_foreign');
		});
		Schema::table('matches', function(Blueprint $table) {
			$table->dropForeign('matches_group_id_foreign');
		});
		Schema::table('medias', function(Blueprint $table) {
			$table->dropForeign('medias_team_id_foreign');
		});
		Schema::table('medias', function(Blueprint $table) {
			$table->dropForeign('medias_match_id_foreign');
		});
		Schema::table('news', function(Blueprint $table) {
			$table->dropForeign('news_team_id_foreign');
		});
	}
}