<?php

class Product extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;

	public function category()
	{
		return $this->belongsTo('Category');
	}

	public function favouritedByUsers()
	{
		return $this->belongsToMany('User', 'favourites');
	}

	public function bestSeller()
	{
		return $this->belongsTo('BestSeller');
	}

	public function offer()
	{
		return $this->belongsTo('Offer');
	}

}