<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function categories()
    {
        return $this->hasMany('Category');
    }

    public function users()
    {
        return $this->hasMany('User');
    }

    public function collections()
    {
        return $this->hasMany('Collection');
    }

    public function watch_laters()
    {
        return $this->hasMany('WatchLater');
    }

    public function favorites()
    {
        return $this->hasMany('Favorite');
    }

}