<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('reservations', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('reservations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('reservation_room', function(Blueprint $table) {
			$table->foreign('room_id')->references('id')->on('rooms')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('reservation_room', function(Blueprint $table) {
			$table->foreign('reservation_id')->references('id')->on('reservations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('rooms', function(Blueprint $table) {
			$table->foreign('accomodation_id')->references('id')->on('rooms')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('amenity_room', function(Blueprint $table) {
			$table->foreign('room_id')->references('id')->on('rooms')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('rates', function(Blueprint $table) {
			$table->foreign('room_id')->references('id')->on('rooms')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('accomodations', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('locations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('locations', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('locations', function(Blueprint $table) {
			$table->foreign('state_id')->references('id')->on('states')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('locations', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('reservations', function(Blueprint $table) {
			$table->dropForeign('reservations_user_id_foreign');
		});
		Schema::table('reservation_room', function(Blueprint $table) {
			$table->dropForeign('reservation_room_room_id_foreign');
		});
		Schema::table('reservation_room', function(Blueprint $table) {
			$table->dropForeign('reservation_room_reservation_id_foreign');
		});
		Schema::table('rooms', function(Blueprint $table) {
			$table->dropForeign('rooms_accomodation_id_foreign');
		});
		Schema::table('amenity_room', function(Blueprint $table) {
			$table->dropForeign('amenity_room_room_id_foreign');
		});
		Schema::table('rates', function(Blueprint $table) {
			$table->dropForeign('rates_room_id_foreign');
		});
		Schema::table('accomodations', function(Blueprint $table) {
			$table->dropForeign('accomodations_location_id_foreign');
		});
		Schema::table('locations', function(Blueprint $table) {
			$table->dropForeign('locations_city_id_foreign');
		});
		Schema::table('locations', function(Blueprint $table) {
			$table->dropForeign('locations_state_id_foreign');
		});
		Schema::table('locations', function(Blueprint $table) {
			$table->dropForeign('locations_country_id_foreign');
		});
	}
}