<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateItemOrderTable extends Migration {

	public function up()
	{
		Schema::create('item_order', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('item_id')->unsigned();
			$table->integer('order_id')->unsigned();
			$table->integer('quantity')->default('1');
			$table->string('special_order', 255)->nullable();
			$table->decimal('price');
		});
	}

	public function down()
	{
		Schema::drop('item_order');
	}
}