<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBerkasTable extends Migration {

	public function up()
	{
		Schema::create('berkas', function(Blueprint $table) {
			$table->increments('id_berkas', true);
			$table->timestamps();
			$table->softDeletes();
			$table->string('no_berkas', 50);
			$table->integer('id_drawing');
			$table->string('no_surat', 100)->nullable();
			$table->string('path', 100);
			$table->integer('status');
			$table->integer('approved');
			$table->integer('kontrak_id');
			$table->string('note', 300)->nullable();
			$table->date('tgl_surat');
			$table->integer('hit_download')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('berkas');
	}
}