<?php

namespace Tour;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Tour extends Eloquent {

	protected $table = 'tours';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function Destination()
	{
		return $this->belongsTo('Destination');
	}

	public function category()
	{
		return $this->belongsTo('Category');
	}

	public function type()
	{
		return $this->belongsTo('Type');
	}

	public function itenaries()
	{
		return $this->hasMany('Itenerary');
	}

	public function prices()
	{
		return $this->hasMany('Price');
	}

	public function reviews()
	{
		return $this->hasMany('Review');
	}

	public function gallery()
	{
		return $this->hasMany('Gallery');
	}

	public function inquires()
	{
		return $this->hasMany('Inquiry');
	}

}