<?php

namespace Tour;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Tour extends Model 
{

    protected $table = 'tours';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function Destination()
    {
        return $this->belongsTo('Destination');
    }

    public function category()
    {
        return $this->belongsTo('Category');
    }

    public function type()
    {
        return $this->belongsTo('Type');
    }

    public function itenaries()
    {
        return $this->hasMany('Itenerary');
    }

    public function prices()
    {
        return $this->hasMany('Price');
    }

    public function reviews()
    {
        return $this->hasMany('Review');
    }

    public function gallery()
    {
        return $this->hasMany('Gallery');
    }

    public function inquires()
    {
        return $this->hasMany('Inquiry');
    }

}