<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCommentsTable extends Migration {

	public function up()
	{
		Schema::create('comments', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('post_id')->unsigned()->nullable();
			$table->string('name');
			$table->string('email');
			$table->text('comment');
			$table->boolean('active')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('comments');
	}
}