<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServiceDetailsTable extends Migration {

	public function up()
	{
		Schema::create('service_details', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('service_id')->unsigned();
			$table->integer('size_id')->unsigned();
			$table->integer('color_id')->unsigned();
			$table->integer('paper_id')->unsigned();
			$table->integer('binding_id')->unsigned();
			$table->integer('cellophane_id')->unsigned();
			$table->double('price', 22,2)->nullable();
			$table->integer('preview_media_id')->unsigned();
			$table->enum('status', array('draft', 'publish'));
			$table->float('discount', 22,2)->default('0');
			$table->enum('discount_type', array('fix', 'percent'));
			$table->integer('cover_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('service_details');
	}
}