<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Attribute extends Eloquent {

	protected $table = 'attributes';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function attributeCategory()
	{
		return $this->belongsTo('AttributeCategory', 'attribute_category_id');
	}

	public function serviceAttributes()
	{
		return $this->hasMany('ServiceAttribute');
	}

}