<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Invoice extends Eloquent {

	protected $table = 'invoices';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function payments()
	{
		return $this->hasMany('Payment');
	}

	public function invoiceDetails()
	{
		return $this->hasMany('InvoiceDetail');
	}

}