<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Service extends Eloquent {

	protected $table = 'services';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function serviceCategory()
	{
		return $this->belongsTo('ServiceCategory', 'service_category_id');
	}

	public function serviceAttributes()
	{
		return $this->hasMany('ServiceAttribute');
	}

	public function serviceDetails()
	{
		return $this->hasMany('ServiceDetail');
	}

}