<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTaskTable extends Migration {

	public function up()
	{
		Schema::create('task', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('project_id')->unsigned()->index();
			$table->string('name', 255)->index()->default('NULL');
			$table->text('description')->default('NULL');
			$table->datetime('start_date')->index();
			$table->datetime('end_date')->index();
			$table->integer('staff_id')->unsigned();
			$table->integer('member_id')->unsigned()->index();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('task');
	}
}