<?php

namespace App\Models\Task;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Project extends Eloquent {

	protected $table = 'project';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('opd_id', 'name', 'start_date', 'end_date', 'description', 'staf_id');
	protected $visible = array('name', 'start_date', 'end_date', 'description');

	public function getClient()
	{
		return $this->hasOne('App\Models\Task\Opd', 'opd_id');
	}

}