<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDoctorsTable extends Migration {

	public function up()
	{
		Schema::create('doctors', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 255);
			$table->string('phone', 255);
			$table->string('email', 255)->unique();
			$table->string('password');
			$table->enum('gender', array(''male'', ''female''));
			$table->boolean('is_active')->default(1);
			$table->longText('description')->nullable();
			$table->string('lang');
			$table->string('doctor_lang');
			$table->string('exprince');
			$table->string('appointment_type');
			$table->longText('exprinces_description')->nullable();
			$table->enum('type', array(''doctor'', ''therapist''))->nullable();
			$table->string('time_appointment');
			$table->string('cost_appointment')->nullable();
			$table->string('commission');
		});
	}

	public function down()
	{
		Schema::drop('doctors');
	}
}